/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rsf.managereqs;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RequestQueueListener;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.managereqs.CallHomeServersBean;
import com.ibm.hwmca.fw.rsf.managereqs.RsfRequestInfo;
import com.ibm.hwmca.fw.rsf.managereqs.RsfRequestsBean;
import com.ibm.hwmca.fw.rsf.managereqs.RsfRequestsConstants;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RsfRequestsTasklet
extends PanelTasklet
implements RsfRequestsConstants,
RequestQueueListener {
    private static final String TRACE_MASKT = "XRSFRQTT";
    private static final String TRACE_MASKF = "XRSFRQTF";
    private static final String TRACE_MASKD = "XRSFRQTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RSF-ReqsTskl");
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private RsfRequestsBean requestsBean;
    private Set rsfImpls;
    private List activeReqInfo = new ArrayList();
    private List waitingReqInfo = new ArrayList();
    private Object requestInfoLock = new Object();

    public RsfRequestsTasklet() {
        this.rsfImpls = RsfManager.getRsfManager().getAllRsf();
        Trace.trace(TRACE_MASKT, "<> RsfRequestsTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        this.deregisterAsRsfQueueListener();
        super.destroy();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.requestsBean = new RsfRequestsBean();
                this.requestsBean.setBeanName("RsfRequestsBean");
                this.registerAsRsfQueueListener();
                response.replace("com.ibm.hwmca.fw.rsf.managereqs.res.RsfRequestsRes", "RsfRequestsPanel", this.requestsBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("RsfRequestsPanel")) {
                    this.serviceRsfRequestsPanel(request, response);
                } else if (source.equals("CallHomeServersPanel")) {
                    this.serviceCallHomeServersPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1140, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRsfRequestsPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceRsfRequestsPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("UpdateRequestInfo")) {
            ArrayList waitingReqs;
            ArrayList activeReqs;
            Object object = this.requestInfoLock;
            synchronized (object) {
                activeReqs = new ArrayList(this.activeReqInfo);
                waitingReqs = new ArrayList(this.waitingReqInfo);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("RequestInfo", new List[]{activeReqs, waitingReqs});
            response.update("RsfRequestsBean", data);
        } else if (command.equals("CancelRequests")) {
            List rsfRequests = (List)request.getData("RequestInfo");
            if (rsfRequests != null) {
                Iterator iterator = rsfRequests.iterator();
                while (iterator.hasNext()) {
                    RsfRequestInfo reqInfo = (RsfRequestInfo)iterator.next();
                    this.cancelRsfRequest(reqInfo.getId());
                }
            }
            response.noAction();
        } else if (command.equals("OpenCallHomeServersPanel")) {
            CallHomeServersBean serversBean = new CallHomeServersBean();
            serversBean.setBeanName("CallHomeServersBean");
            MachineId machine = FcsServer.getFcsServer().getLocalMachineId();
            serversBean.setConsoleName(FcsServer.getFcsServer().getLocalMachineId().getName());
            serversBean.setCallHomeServers(this.getCallHomeServers());
            response.openModalChild("com.ibm.hwmca.fw.rsf.managereqs.res.RsfRequestsRes", "CallHomeServersPanel", serversBean);
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceRsfRequestsPanel()");
    }

    private void serviceCallHomeServersPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceCallHomeServersPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Cancel")) {
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceCallHomeServersPanel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAsRsfQueueListener() {
        Iterator impls = this.rsfImpls.iterator();
        while (impls.hasNext()) {
            RemoteSupportFacility rsf = (RemoteSupportFacility)impls.next();
            Object object = this.requestInfoLock;
            synchronized (object) {
                RsfRequest request;
                List[] requests = rsf.getQueuedRequests(this);
                Iterator active = requests[0].iterator();
                while (active.hasNext()) {
                    request = (RsfRequest)active.next();
                    this.activeReqInfo.add(new RsfRequestInfo(request));
                }
                Iterator waiting = requests[1].iterator();
                while (waiting.hasNext()) {
                    request = (RsfRequest)waiting.next();
                    this.waitingReqInfo.add(new RsfRequestInfo(request));
                }
            }
        }
    }

    private void deregisterAsRsfQueueListener() {
        Iterator iterator = this.rsfImpls.iterator();
        while (iterator.hasNext()) {
            RemoteSupportFacility rsf = (RemoteSupportFacility)iterator.next();
            rsf.removeQueueListener(this);
        }
    }

    private void cancelRsfRequest(String id) {
        Iterator iterator = this.rsfImpls.iterator();
        while (iterator.hasNext()) {
            RemoteSupportFacility rsf = (RemoteSupportFacility)iterator.next();
            RsfRequest request = rsf.getRequest(id);
            if (request == null) continue;
            try {
                request.cancel();
            }
            catch (IllegalStateException ise) {}
        }
    }

    private List getCallHomeServers() {
        ArrayList servers = new ArrayList();
        Iterator iterator = this.rsfImpls.iterator();
        while (iterator.hasNext()) {
            RemoteSupportFacility rsf = (RemoteSupportFacility)iterator.next();
            servers.addAll(rsf.getAvailableCallHomeServers());
        }
        return servers;
    }

    private void updateRsfRequestInfo() {
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setSource(this.getUniqueTaskletRequestId());
            request.setData("Source", "RsfRequestsPanel");
            request.setData("Command", "UpdateRequestInfo");
            this.postRequest("RsfRequestsBean", request);
        }
        catch (TaskletException taskletException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        RsfRequestsTasklet rsfRequestsTasklet = this;
        synchronized (rsfRequestsTasklet) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.taskletRequestId);
            sb.append("-");
            sb.append(++this.taskletRequestNum);
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedToWaiting(RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> addedToWaiting(" + request.getId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RsfRequestInfo reqInfo = new RsfRequestInfo(request);
            int index = this.waitingReqInfo.indexOf(reqInfo);
            if (index == -1) {
                this.waitingReqInfo.add(reqInfo);
            } else {
                this.waitingReqInfo.set(index, reqInfo);
            }
            this.updateRsfRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- addedToWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromWaiting(RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> removedFromWaiting(" + request.getId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            if (this.waitingReqInfo.remove(new RsfRequestInfo(request))) {
                this.updateRsfRequestInfo();
            }
        }
        Trace.trace(TRACE_MASKT, "<- removedFromWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeRequestChanged(RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> activeRequestChanged(" + request.getId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RsfRequestInfo reqInfo = new RsfRequestInfo(request);
            int index = this.activeReqInfo.indexOf(reqInfo);
            if (index >= 0) {
                this.activeReqInfo.set(index, reqInfo);
            } else {
                this.activeReqInfo.add(reqInfo);
            }
            this.updateRsfRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- activeRequestChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromWaitingToActive(RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> moveFromWaitingToActive(" + request.getId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RsfRequestInfo reqInfo = new RsfRequestInfo(request);
            this.waitingReqInfo.remove(reqInfo);
            int index = this.activeReqInfo.indexOf(reqInfo);
            if (index == -1) {
                this.activeReqInfo.add(reqInfo);
            } else {
                this.activeReqInfo.set(index, reqInfo);
            }
            this.updateRsfRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- moveFromWaitingToActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromActive(RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> removedFromActive(" + request.getId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            if (this.activeReqInfo.remove(new RsfRequestInfo(request))) {
                this.updateRsfRequestInfo();
            }
        }
        Trace.trace(TRACE_MASKT, "<- removedFromActive()");
    }
}

